// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Subnet configuration for segment. </summary>
    public partial class WorkloadNetworkSegmentSubnet
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkSegmentSubnet"/>. </summary>
        public WorkloadNetworkSegmentSubnet()
        {
            DhcpRanges = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkSegmentSubnet"/>. </summary>
        /// <param name="dhcpRanges"> DHCP Range assigned for subnet. </param>
        /// <param name="gatewayAddress"> Gateway address. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WorkloadNetworkSegmentSubnet(IList<string> dhcpRanges, string gatewayAddress, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DhcpRanges = dhcpRanges;
            GatewayAddress = gatewayAddress;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> DHCP Range assigned for subnet. </summary>
        public IList<string> DhcpRanges { get; }
        /// <summary> Gateway address. </summary>
        public string GatewayAddress { get; set; }
    }
}
