// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Workload Network Public IP provisioning state. </summary>
    public readonly partial struct WorkloadNetworkPublicIPProvisioningState : IEquatable<WorkloadNetworkPublicIPProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkPublicIPProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkloadNetworkPublicIPProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string BuildingValue = "Building";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";

        /// <summary> Resource has been created. </summary>
        public static WorkloadNetworkPublicIPProvisioningState Succeeded { get; } = new WorkloadNetworkPublicIPProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static WorkloadNetworkPublicIPProvisioningState Failed { get; } = new WorkloadNetworkPublicIPProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static WorkloadNetworkPublicIPProvisioningState Canceled { get; } = new WorkloadNetworkPublicIPProvisioningState(CanceledValue);
        /// <summary> is building. </summary>
        public static WorkloadNetworkPublicIPProvisioningState Building { get; } = new WorkloadNetworkPublicIPProvisioningState(BuildingValue);
        /// <summary> is deleting. </summary>
        public static WorkloadNetworkPublicIPProvisioningState Deleting { get; } = new WorkloadNetworkPublicIPProvisioningState(DeletingValue);
        /// <summary> is updating. </summary>
        public static WorkloadNetworkPublicIPProvisioningState Updating { get; } = new WorkloadNetworkPublicIPProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="WorkloadNetworkPublicIPProvisioningState"/> values are the same. </summary>
        public static bool operator ==(WorkloadNetworkPublicIPProvisioningState left, WorkloadNetworkPublicIPProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkloadNetworkPublicIPProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(WorkloadNetworkPublicIPProvisioningState left, WorkloadNetworkPublicIPProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkloadNetworkPublicIPProvisioningState"/>. </summary>
        public static implicit operator WorkloadNetworkPublicIPProvisioningState(string value) => new WorkloadNetworkPublicIPProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkloadNetworkPublicIPProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkloadNetworkPublicIPProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
