// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> base Workload Network provisioning state. </summary>
    public readonly partial struct WorkloadNetworkProvisioningState : IEquatable<WorkloadNetworkProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkloadNetworkProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string BuildingValue = "Building";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";

        /// <summary> Resource has been created. </summary>
        public static WorkloadNetworkProvisioningState Succeeded { get; } = new WorkloadNetworkProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static WorkloadNetworkProvisioningState Failed { get; } = new WorkloadNetworkProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static WorkloadNetworkProvisioningState Canceled { get; } = new WorkloadNetworkProvisioningState(CanceledValue);
        /// <summary> is building. </summary>
        public static WorkloadNetworkProvisioningState Building { get; } = new WorkloadNetworkProvisioningState(BuildingValue);
        /// <summary> is deleting. </summary>
        public static WorkloadNetworkProvisioningState Deleting { get; } = new WorkloadNetworkProvisioningState(DeletingValue);
        /// <summary> is updating. </summary>
        public static WorkloadNetworkProvisioningState Updating { get; } = new WorkloadNetworkProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="WorkloadNetworkProvisioningState"/> values are the same. </summary>
        public static bool operator ==(WorkloadNetworkProvisioningState left, WorkloadNetworkProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkloadNetworkProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(WorkloadNetworkProvisioningState left, WorkloadNetworkProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkloadNetworkProvisioningState"/>. </summary>
        public static implicit operator WorkloadNetworkProvisioningState(string value) => new WorkloadNetworkProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkloadNetworkProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkloadNetworkProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
