// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Workload Network Port Mirroring provisioning state. </summary>
    public readonly partial struct WorkloadNetworkPortMirroringProfileProvisioningState : IEquatable<WorkloadNetworkPortMirroringProfileProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkPortMirroringProfileProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkloadNetworkPortMirroringProfileProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string BuildingValue = "Building";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";

        /// <summary> Resource has been created. </summary>
        public static WorkloadNetworkPortMirroringProfileProvisioningState Succeeded { get; } = new WorkloadNetworkPortMirroringProfileProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static WorkloadNetworkPortMirroringProfileProvisioningState Failed { get; } = new WorkloadNetworkPortMirroringProfileProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static WorkloadNetworkPortMirroringProfileProvisioningState Canceled { get; } = new WorkloadNetworkPortMirroringProfileProvisioningState(CanceledValue);
        /// <summary> is building. </summary>
        public static WorkloadNetworkPortMirroringProfileProvisioningState Building { get; } = new WorkloadNetworkPortMirroringProfileProvisioningState(BuildingValue);
        /// <summary> is deleting. </summary>
        public static WorkloadNetworkPortMirroringProfileProvisioningState Deleting { get; } = new WorkloadNetworkPortMirroringProfileProvisioningState(DeletingValue);
        /// <summary> is updating. </summary>
        public static WorkloadNetworkPortMirroringProfileProvisioningState Updating { get; } = new WorkloadNetworkPortMirroringProfileProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="WorkloadNetworkPortMirroringProfileProvisioningState"/> values are the same. </summary>
        public static bool operator ==(WorkloadNetworkPortMirroringProfileProvisioningState left, WorkloadNetworkPortMirroringProfileProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkloadNetworkPortMirroringProfileProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(WorkloadNetworkPortMirroringProfileProvisioningState left, WorkloadNetworkPortMirroringProfileProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkloadNetworkPortMirroringProfileProvisioningState"/>. </summary>
        public static implicit operator WorkloadNetworkPortMirroringProfileProvisioningState(string value) => new WorkloadNetworkPortMirroringProfileProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkloadNetworkPortMirroringProfileProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkloadNetworkPortMirroringProfileProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
