// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Workload Network DNS Service provisioning state. </summary>
    public readonly partial struct WorkloadNetworkDnsServiceProvisioningState : IEquatable<WorkloadNetworkDnsServiceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkDnsServiceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkloadNetworkDnsServiceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string BuildingValue = "Building";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";

        /// <summary> Resource has been created. </summary>
        public static WorkloadNetworkDnsServiceProvisioningState Succeeded { get; } = new WorkloadNetworkDnsServiceProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static WorkloadNetworkDnsServiceProvisioningState Failed { get; } = new WorkloadNetworkDnsServiceProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static WorkloadNetworkDnsServiceProvisioningState Canceled { get; } = new WorkloadNetworkDnsServiceProvisioningState(CanceledValue);
        /// <summary> is building. </summary>
        public static WorkloadNetworkDnsServiceProvisioningState Building { get; } = new WorkloadNetworkDnsServiceProvisioningState(BuildingValue);
        /// <summary> is deleting. </summary>
        public static WorkloadNetworkDnsServiceProvisioningState Deleting { get; } = new WorkloadNetworkDnsServiceProvisioningState(DeletingValue);
        /// <summary> is updating. </summary>
        public static WorkloadNetworkDnsServiceProvisioningState Updating { get; } = new WorkloadNetworkDnsServiceProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="WorkloadNetworkDnsServiceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(WorkloadNetworkDnsServiceProvisioningState left, WorkloadNetworkDnsServiceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkloadNetworkDnsServiceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(WorkloadNetworkDnsServiceProvisioningState left, WorkloadNetworkDnsServiceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkloadNetworkDnsServiceProvisioningState"/>. </summary>
        public static implicit operator WorkloadNetworkDnsServiceProvisioningState(string value) => new WorkloadNetworkDnsServiceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkloadNetworkDnsServiceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkloadNetworkDnsServiceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
