// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> a plain text value execution parameter. </summary>
    public partial class ScriptStringExecutionParameterDetails : ScriptExecutionParameterDetails
    {
        /// <summary> Initializes a new instance of <see cref="ScriptStringExecutionParameterDetails"/>. </summary>
        /// <param name="name"> The parameter name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public ScriptStringExecutionParameterDetails(string name) : base(name)
        {
            Argument.AssertNotNull(name, nameof(name));

            ParameterType = ScriptExecutionParameterType.Value;
        }

        /// <summary> Initializes a new instance of <see cref="ScriptStringExecutionParameterDetails"/>. </summary>
        /// <param name="parameterType"> script execution parameter type. </param>
        /// <param name="name"> The parameter name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> The value for the passed parameter. </param>
        internal ScriptStringExecutionParameterDetails(ScriptExecutionParameterType parameterType, string name, IDictionary<string, BinaryData> serializedAdditionalRawData, string value) : base(parameterType, name, serializedAdditionalRawData)
        {
            Value = value;
            ParameterType = parameterType;
        }

        /// <summary> Initializes a new instance of <see cref="ScriptStringExecutionParameterDetails"/> for deserialization. </summary>
        internal ScriptStringExecutionParameterDetails()
        {
        }

        /// <summary> The value for the passed parameter. </summary>
        public string Value { get; set; }
    }
}
