// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Script Parameter types. </summary>
    public readonly partial struct ScriptParameterType : IEquatable<ScriptParameterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScriptParameterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScriptParameterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StringValue = "String";
        private const string SecureStringValue = "SecureString";
        private const string CredentialValue = "Credential";
        private const string IntValue = "Int";
        private const string BoolValue = "Bool";
        private const string FloatValue = "Float";

        /// <summary> is string. </summary>
        public static ScriptParameterType String { get; } = new ScriptParameterType(StringValue);
        /// <summary> is secure string. </summary>
        public static ScriptParameterType SecureString { get; } = new ScriptParameterType(SecureStringValue);
        /// <summary> is credential. </summary>
        public static ScriptParameterType Credential { get; } = new ScriptParameterType(CredentialValue);
        /// <summary> is int. </summary>
        public static ScriptParameterType Int { get; } = new ScriptParameterType(IntValue);
        /// <summary> is bool. </summary>
        public static ScriptParameterType Bool { get; } = new ScriptParameterType(BoolValue);
        /// <summary> is float. </summary>
        public static ScriptParameterType Float { get; } = new ScriptParameterType(FloatValue);
        /// <summary> Determines if two <see cref="ScriptParameterType"/> values are the same. </summary>
        public static bool operator ==(ScriptParameterType left, ScriptParameterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScriptParameterType"/> values are not the same. </summary>
        public static bool operator !=(ScriptParameterType left, ScriptParameterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScriptParameterType"/>. </summary>
        public static implicit operator ScriptParameterType(string value) => new ScriptParameterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScriptParameterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScriptParameterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
