// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Script Package provisioning state. </summary>
    public readonly partial struct ScriptPackageProvisioningState : IEquatable<ScriptPackageProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScriptPackageProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScriptPackageProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Resource has been created. </summary>
        public static ScriptPackageProvisioningState Succeeded { get; } = new ScriptPackageProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static ScriptPackageProvisioningState Failed { get; } = new ScriptPackageProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static ScriptPackageProvisioningState Canceled { get; } = new ScriptPackageProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="ScriptPackageProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ScriptPackageProvisioningState left, ScriptPackageProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScriptPackageProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ScriptPackageProvisioningState left, ScriptPackageProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScriptPackageProvisioningState"/>. </summary>
        public static implicit operator ScriptPackageProvisioningState(string value) => new ScriptPackageProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScriptPackageProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScriptPackageProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
