// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> A script cmdlet provisioning state. </summary>
    public readonly partial struct ScriptCmdletProvisioningState : IEquatable<ScriptCmdletProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScriptCmdletProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScriptCmdletProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Resource has been created. </summary>
        public static ScriptCmdletProvisioningState Succeeded { get; } = new ScriptCmdletProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static ScriptCmdletProvisioningState Failed { get; } = new ScriptCmdletProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static ScriptCmdletProvisioningState Canceled { get; } = new ScriptCmdletProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="ScriptCmdletProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ScriptCmdletProvisioningState left, ScriptCmdletProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScriptCmdletProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ScriptCmdletProvisioningState left, ScriptCmdletProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScriptCmdletProvisioningState"/>. </summary>
        public static implicit operator ScriptCmdletProvisioningState(string value) => new ScriptCmdletProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScriptCmdletProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScriptCmdletProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
