// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Port Mirroring status. </summary>
    public readonly partial struct PortMirroringProfileStatus : IEquatable<PortMirroringProfileStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PortMirroringProfileStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PortMirroringProfileStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SuccessValue = "SUCCESS";
        private const string FailureValue = "FAILURE";

        /// <summary> is success. </summary>
        public static PortMirroringProfileStatus Success { get; } = new PortMirroringProfileStatus(SuccessValue);
        /// <summary> is failure. </summary>
        public static PortMirroringProfileStatus Failure { get; } = new PortMirroringProfileStatus(FailureValue);
        /// <summary> Determines if two <see cref="PortMirroringProfileStatus"/> values are the same. </summary>
        public static bool operator ==(PortMirroringProfileStatus left, PortMirroringProfileStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PortMirroringProfileStatus"/> values are not the same. </summary>
        public static bool operator !=(PortMirroringProfileStatus left, PortMirroringProfileStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PortMirroringProfileStatus"/>. </summary>
        public static implicit operator PortMirroringProfileStatus(string value) => new PortMirroringProfileStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PortMirroringProfileStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PortMirroringProfileStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
