// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Placement Policy type. </summary>
    internal readonly partial struct PlacementPolicyType : IEquatable<PlacementPolicyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PlacementPolicyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PlacementPolicyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string VmVmValue = "VmVm";
        private const string VmHostValue = "VmHost";

        /// <summary> VmVm. </summary>
        public static PlacementPolicyType VmVm { get; } = new PlacementPolicyType(VmVmValue);
        /// <summary> VmHost. </summary>
        public static PlacementPolicyType VmHost { get; } = new PlacementPolicyType(VmHostValue);
        /// <summary> Determines if two <see cref="PlacementPolicyType"/> values are the same. </summary>
        public static bool operator ==(PlacementPolicyType left, PlacementPolicyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PlacementPolicyType"/> values are not the same. </summary>
        public static bool operator !=(PlacementPolicyType left, PlacementPolicyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PlacementPolicyType"/>. </summary>
        public static implicit operator PlacementPolicyType(string value) => new PlacementPolicyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PlacementPolicyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PlacementPolicyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
