// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Placement Policy state. </summary>
    public readonly partial struct PlacementPolicyState : IEquatable<PlacementPolicyState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PlacementPolicyState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PlacementPolicyState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> is enabled. </summary>
        public static PlacementPolicyState Enabled { get; } = new PlacementPolicyState(EnabledValue);
        /// <summary> is disabled. </summary>
        public static PlacementPolicyState Disabled { get; } = new PlacementPolicyState(DisabledValue);
        /// <summary> Determines if two <see cref="PlacementPolicyState"/> values are the same. </summary>
        public static bool operator ==(PlacementPolicyState left, PlacementPolicyState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PlacementPolicyState"/> values are not the same. </summary>
        public static bool operator !=(PlacementPolicyState left, PlacementPolicyState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PlacementPolicyState"/>. </summary>
        public static implicit operator PlacementPolicyState(string value) => new PlacementPolicyState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PlacementPolicyState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PlacementPolicyState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
