// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> An update of a DRS placement policy resource. </summary>
    public partial class PlacementPolicyPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PlacementPolicyPatch"/>. </summary>
        public PlacementPolicyPatch()
        {
            VmMembers = new ChangeTrackingList<ResourceIdentifier>();
            HostMembers = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="PlacementPolicyPatch"/>. </summary>
        /// <param name="state"> Whether the placement policy is enabled or disabled. </param>
        /// <param name="vmMembers"> Virtual machine members list. </param>
        /// <param name="hostMembers"> Host members list. </param>
        /// <param name="affinityStrength"> vm-host placement policy affinity strength (should/must). </param>
        /// <param name="azureHybridBenefitType"> placement policy azure hybrid benefit opt-in type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PlacementPolicyPatch(PlacementPolicyState? state, IList<ResourceIdentifier> vmMembers, IList<string> hostMembers, VmHostPlacementPolicyAffinityStrength? affinityStrength, AzureHybridBenefitType? azureHybridBenefitType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            State = state;
            VmMembers = vmMembers;
            HostMembers = hostMembers;
            AffinityStrength = affinityStrength;
            AzureHybridBenefitType = azureHybridBenefitType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Whether the placement policy is enabled or disabled. </summary>
        public PlacementPolicyState? State { get; set; }
        /// <summary> Virtual machine members list. </summary>
        public IList<ResourceIdentifier> VmMembers { get; }
        /// <summary> Host members list. </summary>
        public IList<string> HostMembers { get; }
        /// <summary> vm-host placement policy affinity strength (should/must). </summary>
        public VmHostPlacementPolicyAffinityStrength? AffinityStrength { get; set; }
        /// <summary> placement policy azure hybrid benefit opt-in type. </summary>
        public AzureHybridBenefitType? AzureHybridBenefitType { get; set; }
    }
}
