// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Optional Param. </summary>
    public readonly partial struct ParameterOptionalityStatus : IEquatable<ParameterOptionalityStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ParameterOptionalityStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ParameterOptionalityStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OptionalValue = "Optional";
        private const string RequiredValue = "Required";

        /// <summary> is optional. </summary>
        public static ParameterOptionalityStatus Optional { get; } = new ParameterOptionalityStatus(OptionalValue);
        /// <summary> is required. </summary>
        public static ParameterOptionalityStatus Required { get; } = new ParameterOptionalityStatus(RequiredValue);
        /// <summary> Determines if two <see cref="ParameterOptionalityStatus"/> values are the same. </summary>
        public static bool operator ==(ParameterOptionalityStatus left, ParameterOptionalityStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ParameterOptionalityStatus"/> values are not the same. </summary>
        public static bool operator !=(ParameterOptionalityStatus left, ParameterOptionalityStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ParameterOptionalityStatus"/>. </summary>
        public static implicit operator ParameterOptionalityStatus(string value) => new ParameterOptionalityStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ParameterOptionalityStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ParameterOptionalityStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
