// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> a powershell credential object. </summary>
    public partial class PSCredentialExecutionParameterDetails : ScriptExecutionParameterDetails
    {
        /// <summary> Initializes a new instance of <see cref="PSCredentialExecutionParameterDetails"/>. </summary>
        /// <param name="name"> The parameter name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public PSCredentialExecutionParameterDetails(string name) : base(name)
        {
            Argument.AssertNotNull(name, nameof(name));

            ParameterType = ScriptExecutionParameterType.Credential;
        }

        /// <summary> Initializes a new instance of <see cref="PSCredentialExecutionParameterDetails"/>. </summary>
        /// <param name="parameterType"> script execution parameter type. </param>
        /// <param name="name"> The parameter name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="username"> username for login. </param>
        /// <param name="password"> password for login. </param>
        internal PSCredentialExecutionParameterDetails(ScriptExecutionParameterType parameterType, string name, IDictionary<string, BinaryData> serializedAdditionalRawData, string username, string password) : base(parameterType, name, serializedAdditionalRawData)
        {
            Username = username;
            Password = password;
            ParameterType = parameterType;
        }

        /// <summary> Initializes a new instance of <see cref="PSCredentialExecutionParameterDetails"/> for deserialization. </summary>
        internal PSCredentialExecutionParameterDetails()
        {
        }

        /// <summary> username for login. </summary>
        public string Username { get; set; }
        /// <summary> password for login. </summary>
        public string Password { get; set; }
    }
}
