// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> NSX public IP quota raised. </summary>
    public readonly partial struct NsxPublicIPQuotaRaisedEnum : IEquatable<NsxPublicIPQuotaRaisedEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NsxPublicIPQuotaRaisedEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NsxPublicIPQuotaRaisedEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> is enabled. </summary>
        public static NsxPublicIPQuotaRaisedEnum Enabled { get; } = new NsxPublicIPQuotaRaisedEnum(EnabledValue);
        /// <summary> is disabled. </summary>
        public static NsxPublicIPQuotaRaisedEnum Disabled { get; } = new NsxPublicIPQuotaRaisedEnum(DisabledValue);
        /// <summary> Determines if two <see cref="NsxPublicIPQuotaRaisedEnum"/> values are the same. </summary>
        public static bool operator ==(NsxPublicIPQuotaRaisedEnum left, NsxPublicIPQuotaRaisedEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NsxPublicIPQuotaRaisedEnum"/> values are not the same. </summary>
        public static bool operator !=(NsxPublicIPQuotaRaisedEnum left, NsxPublicIPQuotaRaisedEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NsxPublicIPQuotaRaisedEnum"/>. </summary>
        public static implicit operator NsxPublicIPQuotaRaisedEnum(string value) => new NsxPublicIPQuotaRaisedEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NsxPublicIPQuotaRaisedEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NsxPublicIPQuotaRaisedEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
