// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> private cloud provisioning state. </summary>
    public readonly partial struct IscsiPathProvisioningState : IEquatable<IscsiPathProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IscsiPathProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IscsiPathProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string PendingValue = "Pending";
        private const string BuildingValue = "Building";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";

        /// <summary> Resource has been created. </summary>
        public static IscsiPathProvisioningState Succeeded { get; } = new IscsiPathProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static IscsiPathProvisioningState Failed { get; } = new IscsiPathProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static IscsiPathProvisioningState Canceled { get; } = new IscsiPathProvisioningState(CanceledValue);
        /// <summary> is pending. </summary>
        public static IscsiPathProvisioningState Pending { get; } = new IscsiPathProvisioningState(PendingValue);
        /// <summary> is building. </summary>
        public static IscsiPathProvisioningState Building { get; } = new IscsiPathProvisioningState(BuildingValue);
        /// <summary> is deleting. </summary>
        public static IscsiPathProvisioningState Deleting { get; } = new IscsiPathProvisioningState(DeletingValue);
        /// <summary> is updating. </summary>
        public static IscsiPathProvisioningState Updating { get; } = new IscsiPathProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="IscsiPathProvisioningState"/> values are the same. </summary>
        public static bool operator ==(IscsiPathProvisioningState left, IscsiPathProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IscsiPathProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(IscsiPathProvisioningState left, IscsiPathProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IscsiPathProvisioningState"/>. </summary>
        public static implicit operator IscsiPathProvisioningState(string value) => new IscsiPathProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IscsiPathProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IscsiPathProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
