// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> HCX Enterprise Site status. </summary>
    public readonly partial struct HcxEnterpriseSiteStatus : IEquatable<HcxEnterpriseSiteStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HcxEnterpriseSiteStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HcxEnterpriseSiteStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AvailableValue = "Available";
        private const string ConsumedValue = "Consumed";
        private const string DeactivatedValue = "Deactivated";
        private const string DeletedValue = "Deleted";

        /// <summary> is available. </summary>
        public static HcxEnterpriseSiteStatus Available { get; } = new HcxEnterpriseSiteStatus(AvailableValue);
        /// <summary> is consumed. </summary>
        public static HcxEnterpriseSiteStatus Consumed { get; } = new HcxEnterpriseSiteStatus(ConsumedValue);
        /// <summary> is deactivated. </summary>
        public static HcxEnterpriseSiteStatus Deactivated { get; } = new HcxEnterpriseSiteStatus(DeactivatedValue);
        /// <summary> is deleted. </summary>
        public static HcxEnterpriseSiteStatus Deleted { get; } = new HcxEnterpriseSiteStatus(DeletedValue);
        /// <summary> Determines if two <see cref="HcxEnterpriseSiteStatus"/> values are the same. </summary>
        public static bool operator ==(HcxEnterpriseSiteStatus left, HcxEnterpriseSiteStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HcxEnterpriseSiteStatus"/> values are not the same. </summary>
        public static bool operator !=(HcxEnterpriseSiteStatus left, HcxEnterpriseSiteStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HcxEnterpriseSiteStatus"/>. </summary>
        public static implicit operator HcxEnterpriseSiteStatus(string value) => new HcxEnterpriseSiteStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HcxEnterpriseSiteStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HcxEnterpriseSiteStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
