// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> An ExpressRoute Circuit. </summary>
    public partial class ExpressRouteCircuit
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuit"/>. </summary>
        public ExpressRouteCircuit()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuit"/>. </summary>
        /// <param name="primarySubnet"> CIDR of primary subnet. </param>
        /// <param name="secondarySubnet"> CIDR of secondary subnet. </param>
        /// <param name="expressRouteId"> Identifier of the ExpressRoute Circuit (Microsoft Colo only). </param>
        /// <param name="expressRoutePrivatePeeringId"> ExpressRoute Circuit private peering identifier. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExpressRouteCircuit(string primarySubnet, string secondarySubnet, ResourceIdentifier expressRouteId, ResourceIdentifier expressRoutePrivatePeeringId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrimarySubnet = primarySubnet;
            SecondarySubnet = secondarySubnet;
            ExpressRouteId = expressRouteId;
            ExpressRoutePrivatePeeringId = expressRoutePrivatePeeringId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> CIDR of primary subnet. </summary>
        public string PrimarySubnet { get; }
        /// <summary> CIDR of secondary subnet. </summary>
        public string SecondarySubnet { get; }
        /// <summary> Identifier of the ExpressRoute Circuit (Microsoft Colo only). </summary>
        public ResourceIdentifier ExpressRouteId { get; }
        /// <summary> ExpressRoute Circuit private peering identifier. </summary>
        public ResourceIdentifier ExpressRoutePrivatePeeringId { get; }
    }
}
