// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Avs.Models
{
    public partial class ExpressRouteCircuit : IUtf8JsonSerializable, IJsonModel<ExpressRouteCircuit>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ExpressRouteCircuit>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ExpressRouteCircuit>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteCircuit>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExpressRouteCircuit)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(PrimarySubnet))
            {
                writer.WritePropertyName("primarySubnet"u8);
                writer.WriteStringValue(PrimarySubnet);
            }
            if (options.Format != "W" && Optional.IsDefined(SecondarySubnet))
            {
                writer.WritePropertyName("secondarySubnet"u8);
                writer.WriteStringValue(SecondarySubnet);
            }
            if (options.Format != "W" && Optional.IsDefined(ExpressRouteId))
            {
                writer.WritePropertyName("expressRouteID"u8);
                writer.WriteStringValue(ExpressRouteId);
            }
            if (options.Format != "W" && Optional.IsDefined(ExpressRoutePrivatePeeringId))
            {
                writer.WritePropertyName("expressRoutePrivatePeeringID"u8);
                writer.WriteStringValue(ExpressRoutePrivatePeeringId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ExpressRouteCircuit IJsonModel<ExpressRouteCircuit>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteCircuit>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExpressRouteCircuit)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeExpressRouteCircuit(document.RootElement, options);
        }

        internal static ExpressRouteCircuit DeserializeExpressRouteCircuit(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string primarySubnet = default;
            string secondarySubnet = default;
            ResourceIdentifier expressRouteId = default;
            ResourceIdentifier expressRoutePrivatePeeringId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("primarySubnet"u8))
                {
                    primarySubnet = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secondarySubnet"u8))
                {
                    secondarySubnet = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("expressRouteID"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    expressRouteId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("expressRoutePrivatePeeringID"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    expressRoutePrivatePeeringId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ExpressRouteCircuit(primarySubnet, secondarySubnet, expressRouteId, expressRoutePrivatePeeringId, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ExpressRouteCircuit>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteCircuit>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ExpressRouteCircuit)} does not support writing '{options.Format}' format.");
            }
        }

        ExpressRouteCircuit IPersistableModel<ExpressRouteCircuit>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteCircuit>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeExpressRouteCircuit(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ExpressRouteCircuit)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ExpressRouteCircuit>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
