// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Express Route Circuit Authorization provisioning state. </summary>
    public readonly partial struct ExpressRouteAuthorizationProvisioningState : IEquatable<ExpressRouteAuthorizationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExpressRouteAuthorizationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExpressRouteAuthorizationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string UpdatingValue = "Updating";

        /// <summary> Resource has been created. </summary>
        public static ExpressRouteAuthorizationProvisioningState Succeeded { get; } = new ExpressRouteAuthorizationProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static ExpressRouteAuthorizationProvisioningState Failed { get; } = new ExpressRouteAuthorizationProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static ExpressRouteAuthorizationProvisioningState Canceled { get; } = new ExpressRouteAuthorizationProvisioningState(CanceledValue);
        /// <summary> is updating. </summary>
        public static ExpressRouteAuthorizationProvisioningState Updating { get; } = new ExpressRouteAuthorizationProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="ExpressRouteAuthorizationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ExpressRouteAuthorizationProvisioningState left, ExpressRouteAuthorizationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExpressRouteAuthorizationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ExpressRouteAuthorizationProvisioningState left, ExpressRouteAuthorizationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExpressRouteAuthorizationProvisioningState"/>. </summary>
        public static implicit operator ExpressRouteAuthorizationProvisioningState(string value) => new ExpressRouteAuthorizationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExpressRouteAuthorizationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExpressRouteAuthorizationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
