// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> An Elastic SAN volume from Microsoft.ElasticSan provider. </summary>
    internal partial class ElasticSanVolume
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ElasticSanVolume"/>. </summary>
        /// <param name="targetId"> Azure resource ID of the Elastic SAN Volume. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="targetId"/> is null. </exception>
        public ElasticSanVolume(ResourceIdentifier targetId)
        {
            Argument.AssertNotNull(targetId, nameof(targetId));

            TargetId = targetId;
        }

        /// <summary> Initializes a new instance of <see cref="ElasticSanVolume"/>. </summary>
        /// <param name="targetId"> Azure resource ID of the Elastic SAN Volume. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ElasticSanVolume(ResourceIdentifier targetId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TargetId = targetId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ElasticSanVolume"/> for deserialization. </summary>
        internal ElasticSanVolume()
        {
        }

        /// <summary> Azure resource ID of the Elastic SAN Volume. </summary>
        public ResourceIdentifier TargetId { get; set; }
    }
}
