// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> DNS service status. </summary>
    public readonly partial struct DnsServiceStatus : IEquatable<DnsServiceStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DnsServiceStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DnsServiceStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SuccessValue = "SUCCESS";
        private const string FailureValue = "FAILURE";

        /// <summary> is success. </summary>
        public static DnsServiceStatus Success { get; } = new DnsServiceStatus(SuccessValue);
        /// <summary> is failure. </summary>
        public static DnsServiceStatus Failure { get; } = new DnsServiceStatus(FailureValue);
        /// <summary> Determines if two <see cref="DnsServiceStatus"/> values are the same. </summary>
        public static bool operator ==(DnsServiceStatus left, DnsServiceStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DnsServiceStatus"/> values are not the same. </summary>
        public static bool operator !=(DnsServiceStatus left, DnsServiceStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DnsServiceStatus"/>. </summary>
        public static implicit operator DnsServiceStatus(string value) => new DnsServiceStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DnsServiceStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DnsServiceStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
