// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Type of DHCP: SERVER or RELAY. </summary>
    internal readonly partial struct DhcpTypeEnum : IEquatable<DhcpTypeEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DhcpTypeEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DhcpTypeEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ServerValue = "SERVER";
        private const string RelayValue = "RELAY";

        /// <summary> SERVER. </summary>
        public static DhcpTypeEnum Server { get; } = new DhcpTypeEnum(ServerValue);
        /// <summary> RELAY. </summary>
        public static DhcpTypeEnum Relay { get; } = new DhcpTypeEnum(RelayValue);
        /// <summary> Determines if two <see cref="DhcpTypeEnum"/> values are the same. </summary>
        public static bool operator ==(DhcpTypeEnum left, DhcpTypeEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DhcpTypeEnum"/> values are not the same. </summary>
        public static bool operator !=(DhcpTypeEnum left, DhcpTypeEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DhcpTypeEnum"/>. </summary>
        public static implicit operator DhcpTypeEnum(string value) => new DhcpTypeEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DhcpTypeEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DhcpTypeEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
