// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> datastore status. </summary>
    public readonly partial struct DatastoreStatus : IEquatable<DatastoreStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DatastoreStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DatastoreStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string AccessibleValue = "Accessible";
        private const string InaccessibleValue = "Inaccessible";
        private const string AttachedValue = "Attached";
        private const string DetachedValue = "Detached";
        private const string LostCommunicationValue = "LostCommunication";
        private const string DeadOrErrorValue = "DeadOrError";

        /// <summary> is unknown. </summary>
        public static DatastoreStatus Unknown { get; } = new DatastoreStatus(UnknownValue);
        /// <summary> is accessible. </summary>
        public static DatastoreStatus Accessible { get; } = new DatastoreStatus(AccessibleValue);
        /// <summary> is inaccessible. </summary>
        public static DatastoreStatus Inaccessible { get; } = new DatastoreStatus(InaccessibleValue);
        /// <summary> is attached. </summary>
        public static DatastoreStatus Attached { get; } = new DatastoreStatus(AttachedValue);
        /// <summary> is detached. </summary>
        public static DatastoreStatus Detached { get; } = new DatastoreStatus(DetachedValue);
        /// <summary> is lost communication. </summary>
        public static DatastoreStatus LostCommunication { get; } = new DatastoreStatus(LostCommunicationValue);
        /// <summary> is dead or error. </summary>
        public static DatastoreStatus DeadOrError { get; } = new DatastoreStatus(DeadOrErrorValue);
        /// <summary> Determines if two <see cref="DatastoreStatus"/> values are the same. </summary>
        public static bool operator ==(DatastoreStatus left, DatastoreStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DatastoreStatus"/> values are not the same. </summary>
        public static bool operator !=(DatastoreStatus left, DatastoreStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DatastoreStatus"/>. </summary>
        public static implicit operator DatastoreStatus(string value) => new DatastoreStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DatastoreStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DatastoreStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
