// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Azure Hybrid Benefit type. </summary>
    public readonly partial struct AzureHybridBenefitType : IEquatable<AzureHybridBenefitType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureHybridBenefitType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureHybridBenefitType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlHostValue = "SqlHost";
        private const string NoneValue = "None";

        /// <summary> is SqlHost. </summary>
        public static AzureHybridBenefitType SqlHost { get; } = new AzureHybridBenefitType(SqlHostValue);
        /// <summary> is None. </summary>
        public static AzureHybridBenefitType None { get; } = new AzureHybridBenefitType(NoneValue);
        /// <summary> Determines if two <see cref="AzureHybridBenefitType"/> values are the same. </summary>
        public static bool operator ==(AzureHybridBenefitType left, AzureHybridBenefitType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureHybridBenefitType"/> values are not the same. </summary>
        public static bool operator !=(AzureHybridBenefitType left, AzureHybridBenefitType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureHybridBenefitType"/>. </summary>
        public static implicit operator AzureHybridBenefitType(string value) => new AzureHybridBenefitType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureHybridBenefitType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureHybridBenefitType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
