// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Virtual Machine provisioning state. </summary>
    public readonly partial struct AvsVirtualMachineProvisioningState : IEquatable<AvsVirtualMachineProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AvsVirtualMachineProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AvsVirtualMachineProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Resource has been created. </summary>
        public static AvsVirtualMachineProvisioningState Succeeded { get; } = new AvsVirtualMachineProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static AvsVirtualMachineProvisioningState Failed { get; } = new AvsVirtualMachineProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static AvsVirtualMachineProvisioningState Canceled { get; } = new AvsVirtualMachineProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="AvsVirtualMachineProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AvsVirtualMachineProvisioningState left, AvsVirtualMachineProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AvsVirtualMachineProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AvsVirtualMachineProvisioningState left, AvsVirtualMachineProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AvsVirtualMachineProvisioningState"/>. </summary>
        public static implicit operator AvsVirtualMachineProvisioningState(string value) => new AvsVirtualMachineProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AvsVirtualMachineProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AvsVirtualMachineProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
