// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> trial status. </summary>
    public readonly partial struct AvsSubscriptionTrialStatus : IEquatable<AvsSubscriptionTrialStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AvsSubscriptionTrialStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AvsSubscriptionTrialStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrialAvailableValue = "TrialAvailable";
        private const string TrialUsedValue = "TrialUsed";
        private const string TrialDisabledValue = "TrialDisabled";

        /// <summary> is available. </summary>
        public static AvsSubscriptionTrialStatus TrialAvailable { get; } = new AvsSubscriptionTrialStatus(TrialAvailableValue);
        /// <summary> is used. </summary>
        public static AvsSubscriptionTrialStatus TrialUsed { get; } = new AvsSubscriptionTrialStatus(TrialUsedValue);
        /// <summary> is disabled. </summary>
        public static AvsSubscriptionTrialStatus TrialDisabled { get; } = new AvsSubscriptionTrialStatus(TrialDisabledValue);
        /// <summary> Determines if two <see cref="AvsSubscriptionTrialStatus"/> values are the same. </summary>
        public static bool operator ==(AvsSubscriptionTrialStatus left, AvsSubscriptionTrialStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AvsSubscriptionTrialStatus"/> values are not the same. </summary>
        public static bool operator !=(AvsSubscriptionTrialStatus left, AvsSubscriptionTrialStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AvsSubscriptionTrialStatus"/>. </summary>
        public static implicit operator AvsSubscriptionTrialStatus(string value) => new AvsSubscriptionTrialStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AvsSubscriptionTrialStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AvsSubscriptionTrialStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
