// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Avs.Models
{
    internal static partial class AvsSkuTierExtensions
    {
        public static string ToSerialString(this AvsSkuTier value) => value switch
        {
            AvsSkuTier.Free => "Free",
            AvsSkuTier.Basic => "Basic",
            AvsSkuTier.Standard => "Standard",
            AvsSkuTier.Premium => "Premium",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AvsSkuTier value.")
        };

        public static AvsSkuTier ToAvsSkuTier(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Free")) return AvsSkuTier.Free;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Basic")) return AvsSkuTier.Basic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Standard")) return AvsSkuTier.Standard;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Premium")) return AvsSkuTier.Premium;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AvsSkuTier value.");
        }
    }
}
