// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> An update to a private cloud resource. </summary>
    public partial class AvsPrivateCloudPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AvsPrivateCloudPatch"/>. </summary>
        public AvsPrivateCloudPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
            IdentitySources = new ChangeTrackingList<SingleSignOnIdentitySource>();
            ExtendedNetworkBlocks = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AvsPrivateCloudPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="sku"> The SKU (Stock Keeping Unit) assigned to this resource. </param>
        /// <param name="identity"> The managed service identities assigned to this resource. Current supported identity types: None, SystemAssigned. </param>
        /// <param name="managementCluster"> The default cluster used for management. </param>
        /// <param name="internet"> Connectivity to internet is enabled or disabled. </param>
        /// <param name="identitySources"> vCenter Single Sign On Identity Sources. </param>
        /// <param name="availability"> Properties describing how the cloud is distributed across availability zones. </param>
        /// <param name="encryption"> Customer managed key encryption, can be enabled or disabled. </param>
        /// <param name="extendedNetworkBlocks">
        /// Array of additional networks noncontiguous with networkBlock. Networks must be
        /// unique and non-overlapping across VNet in your subscription, on-premise, and
        /// this privateCloud networkBlock attribute. Make sure the CIDR format conforms to
        /// (A.B.C.D/X).
        /// </param>
        /// <param name="dnsZoneType"> The type of DNS zone to use. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AvsPrivateCloudPatch(IDictionary<string, string> tags, AvsSku sku, ManagedServiceIdentity identity, AvsManagementCluster managementCluster, InternetConnectivityState? internet, IList<SingleSignOnIdentitySource> identitySources, PrivateCloudAvailabilityProperties availability, CustomerManagedEncryption encryption, IList<string> extendedNetworkBlocks, AvsDnsZoneType? dnsZoneType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tags = tags;
            Sku = sku;
            Identity = identity;
            ManagementCluster = managementCluster;
            Internet = internet;
            IdentitySources = identitySources;
            Availability = availability;
            Encryption = encryption;
            ExtendedNetworkBlocks = extendedNetworkBlocks;
            DnsZoneType = dnsZoneType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource tags. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> The SKU (Stock Keeping Unit) assigned to this resource. </summary>
        public AvsSku Sku { get; set; }
        /// <summary> The managed service identities assigned to this resource. Current supported identity types: None, SystemAssigned. </summary>
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> The default cluster used for management. </summary>
        public AvsManagementCluster ManagementCluster { get; set; }
        /// <summary> Connectivity to internet is enabled or disabled. </summary>
        public InternetConnectivityState? Internet { get; set; }
        /// <summary> vCenter Single Sign On Identity Sources. </summary>
        public IList<SingleSignOnIdentitySource> IdentitySources { get; }
        /// <summary> Properties describing how the cloud is distributed across availability zones. </summary>
        public PrivateCloudAvailabilityProperties Availability { get; set; }
        /// <summary> Customer managed key encryption, can be enabled or disabled. </summary>
        public CustomerManagedEncryption Encryption { get; set; }
        /// <summary>
        /// Array of additional networks noncontiguous with networkBlock. Networks must be
        /// unique and non-overlapping across VNet in your subscription, on-premise, and
        /// this privateCloud networkBlock attribute. Make sure the CIDR format conforms to
        /// (A.B.C.D/X).
        /// </summary>
        public IList<string> ExtendedNetworkBlocks { get; }
        /// <summary> The type of DNS zone to use. </summary>
        public AvsDnsZoneType? DnsZoneType { get; set; }
    }
}
