// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Avs.Models
{
    public partial class AvsPrivateCloudEndpoints : IUtf8JsonSerializable, IJsonModel<AvsPrivateCloudEndpoints>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AvsPrivateCloudEndpoints>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AvsPrivateCloudEndpoints>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvsPrivateCloudEndpoints>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AvsPrivateCloudEndpoints)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(NsxtManager))
            {
                writer.WritePropertyName("nsxtManager"u8);
                writer.WriteStringValue(NsxtManager);
            }
            if (options.Format != "W" && Optional.IsDefined(Vcsa))
            {
                writer.WritePropertyName("vcsa"u8);
                writer.WriteStringValue(Vcsa);
            }
            if (options.Format != "W" && Optional.IsDefined(HcxCloudManager))
            {
                writer.WritePropertyName("hcxCloudManager"u8);
                writer.WriteStringValue(HcxCloudManager);
            }
            if (options.Format != "W" && Optional.IsDefined(NsxtManagerIP))
            {
                writer.WritePropertyName("nsxtManagerIp"u8);
                writer.WriteStringValue(NsxtManagerIP);
            }
            if (options.Format != "W" && Optional.IsDefined(VcenterIP))
            {
                writer.WritePropertyName("vcenterIp"u8);
                writer.WriteStringValue(VcenterIP);
            }
            if (options.Format != "W" && Optional.IsDefined(HcxCloudManagerIP))
            {
                writer.WritePropertyName("hcxCloudManagerIp"u8);
                writer.WriteStringValue(HcxCloudManagerIP);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AvsPrivateCloudEndpoints IJsonModel<AvsPrivateCloudEndpoints>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvsPrivateCloudEndpoints>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AvsPrivateCloudEndpoints)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAvsPrivateCloudEndpoints(document.RootElement, options);
        }

        internal static AvsPrivateCloudEndpoints DeserializeAvsPrivateCloudEndpoints(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string nsxtManager = default;
            string vcsa = default;
            string hcxCloudManager = default;
            string nsxtManagerIP = default;
            string vcenterIP = default;
            string hcxCloudManagerIP = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("nsxtManager"u8))
                {
                    nsxtManager = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vcsa"u8))
                {
                    vcsa = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("hcxCloudManager"u8))
                {
                    hcxCloudManager = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("nsxtManagerIp"u8))
                {
                    nsxtManagerIP = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vcenterIp"u8))
                {
                    vcenterIP = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("hcxCloudManagerIp"u8))
                {
                    hcxCloudManagerIP = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AvsPrivateCloudEndpoints(
                nsxtManager,
                vcsa,
                hcxCloudManager,
                nsxtManagerIP,
                vcenterIP,
                hcxCloudManagerIP,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AvsPrivateCloudEndpoints>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvsPrivateCloudEndpoints>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AvsPrivateCloudEndpoints)} does not support writing '{options.Format}' format.");
            }
        }

        AvsPrivateCloudEndpoints IPersistableModel<AvsPrivateCloudEndpoints>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvsPrivateCloudEndpoints>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAvsPrivateCloudEndpoints(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AvsPrivateCloudEndpoints)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AvsPrivateCloudEndpoints>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
