// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Affinity type. </summary>
    public readonly partial struct AvsPlacementPolicyAffinityType : IEquatable<AvsPlacementPolicyAffinityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AvsPlacementPolicyAffinityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AvsPlacementPolicyAffinityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AffinityValue = "Affinity";
        private const string AntiAffinityValue = "AntiAffinity";

        /// <summary> is affinity. </summary>
        public static AvsPlacementPolicyAffinityType Affinity { get; } = new AvsPlacementPolicyAffinityType(AffinityValue);
        /// <summary> is anti-affinity. </summary>
        public static AvsPlacementPolicyAffinityType AntiAffinity { get; } = new AvsPlacementPolicyAffinityType(AntiAffinityValue);
        /// <summary> Determines if two <see cref="AvsPlacementPolicyAffinityType"/> values are the same. </summary>
        public static bool operator ==(AvsPlacementPolicyAffinityType left, AvsPlacementPolicyAffinityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AvsPlacementPolicyAffinityType"/> values are not the same. </summary>
        public static bool operator !=(AvsPlacementPolicyAffinityType left, AvsPlacementPolicyAffinityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AvsPlacementPolicyAffinityType"/>. </summary>
        public static implicit operator AvsPlacementPolicyAffinityType(string value) => new AvsPlacementPolicyAffinityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AvsPlacementPolicyAffinityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AvsPlacementPolicyAffinityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
