// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> The properties of a management cluster. </summary>
    public partial class AvsManagementCluster
    {
        /// <summary> Initializes a new instance of <see cref="AvsManagementCluster"/>. </summary>
        public AvsManagementCluster()
        {
            Hosts = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AvsManagementCluster"/>. </summary>
        /// <param name="clusterSize"> The cluster size. </param>
        /// <param name="provisioningState"> The state of the cluster provisioning. </param>
        /// <param name="clusterId"> The identity. </param>
        /// <param name="hosts"> The hosts. </param>
        /// <param name="vsanDatastoreName"> Name of the vsan datastore associated with the cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AvsManagementCluster(int? clusterSize, AvsPrivateCloudClusterProvisioningState? provisioningState, int? clusterId, IList<string> hosts, string vsanDatastoreName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClusterSize = clusterSize;
            ProvisioningState = provisioningState;
            ClusterId = clusterId;
            Hosts = hosts;
            VsanDatastoreName = vsanDatastoreName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }
        /// <summary> Name of the vsan datastore associated with the cluster. </summary>
        public string VsanDatastoreName { get; set; }
    }
}
