// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Whether the encryption version is fixed or auto-detected. </summary>
    public readonly partial struct AvsEncryptionVersionType : IEquatable<AvsEncryptionVersionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AvsEncryptionVersionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AvsEncryptionVersionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FixedValue = "Fixed";
        private const string AutoDetectedValue = "AutoDetected";

        /// <summary> is fixed. </summary>
        public static AvsEncryptionVersionType Fixed { get; } = new AvsEncryptionVersionType(FixedValue);
        /// <summary> is auto-detected. </summary>
        public static AvsEncryptionVersionType AutoDetected { get; } = new AvsEncryptionVersionType(AutoDetectedValue);
        /// <summary> Determines if two <see cref="AvsEncryptionVersionType"/> values are the same. </summary>
        public static bool operator ==(AvsEncryptionVersionType left, AvsEncryptionVersionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AvsEncryptionVersionType"/> values are not the same. </summary>
        public static bool operator !=(AvsEncryptionVersionType left, AvsEncryptionVersionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AvsEncryptionVersionType"/>. </summary>
        public static implicit operator AvsEncryptionVersionType(string value) => new AvsEncryptionVersionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AvsEncryptionVersionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AvsEncryptionVersionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
