// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Whether the the encryption key is connected or access denied. </summary>
    public readonly partial struct AvsEncryptionKeyStatus : IEquatable<AvsEncryptionKeyStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AvsEncryptionKeyStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AvsEncryptionKeyStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConnectedValue = "Connected";
        private const string AccessDeniedValue = "AccessDenied";

        /// <summary> is connected. </summary>
        public static AvsEncryptionKeyStatus Connected { get; } = new AvsEncryptionKeyStatus(ConnectedValue);
        /// <summary> is access denied. </summary>
        public static AvsEncryptionKeyStatus AccessDenied { get; } = new AvsEncryptionKeyStatus(AccessDeniedValue);
        /// <summary> Determines if two <see cref="AvsEncryptionKeyStatus"/> values are the same. </summary>
        public static bool operator ==(AvsEncryptionKeyStatus left, AvsEncryptionKeyStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AvsEncryptionKeyStatus"/> values are not the same. </summary>
        public static bool operator !=(AvsEncryptionKeyStatus left, AvsEncryptionKeyStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AvsEncryptionKeyStatus"/>. </summary>
        public static implicit operator AvsEncryptionKeyStatus(string value) => new AvsEncryptionKeyStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AvsEncryptionKeyStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AvsEncryptionKeyStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
