// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Cloud Link status. </summary>
    public readonly partial struct AvsCloudLinkStatus : IEquatable<AvsCloudLinkStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AvsCloudLinkStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AvsCloudLinkStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string BuildingValue = "Building";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> is active. </summary>
        public static AvsCloudLinkStatus Active { get; } = new AvsCloudLinkStatus(ActiveValue);
        /// <summary> is building. </summary>
        public static AvsCloudLinkStatus Building { get; } = new AvsCloudLinkStatus(BuildingValue);
        /// <summary> is deleting. </summary>
        public static AvsCloudLinkStatus Deleting { get; } = new AvsCloudLinkStatus(DeletingValue);
        /// <summary> is failed. </summary>
        public static AvsCloudLinkStatus Failed { get; } = new AvsCloudLinkStatus(FailedValue);
        /// <summary> is disconnected. </summary>
        public static AvsCloudLinkStatus Disconnected { get; } = new AvsCloudLinkStatus(DisconnectedValue);
        /// <summary> Determines if two <see cref="AvsCloudLinkStatus"/> values are the same. </summary>
        public static bool operator ==(AvsCloudLinkStatus left, AvsCloudLinkStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AvsCloudLinkStatus"/> values are not the same. </summary>
        public static bool operator !=(AvsCloudLinkStatus left, AvsCloudLinkStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AvsCloudLinkStatus"/>. </summary>
        public static implicit operator AvsCloudLinkStatus(string value) => new AvsCloudLinkStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AvsCloudLinkStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AvsCloudLinkStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
