// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> cloud link provisioning state. </summary>
    public readonly partial struct AvsCloudLinkProvisioningState : IEquatable<AvsCloudLinkProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AvsCloudLinkProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AvsCloudLinkProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Resource has been created. </summary>
        public static AvsCloudLinkProvisioningState Succeeded { get; } = new AvsCloudLinkProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static AvsCloudLinkProvisioningState Failed { get; } = new AvsCloudLinkProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static AvsCloudLinkProvisioningState Canceled { get; } = new AvsCloudLinkProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="AvsCloudLinkProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AvsCloudLinkProvisioningState left, AvsCloudLinkProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AvsCloudLinkProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AvsCloudLinkProvisioningState left, AvsCloudLinkProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AvsCloudLinkProvisioningState"/>. </summary>
        public static implicit operator AvsCloudLinkProvisioningState(string value) => new AvsCloudLinkProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AvsCloudLinkProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AvsCloudLinkProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
