// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Whether the private clouds is available in a single zone or two zones. </summary>
    public readonly partial struct AvailabilityStrategy : IEquatable<AvailabilityStrategy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AvailabilityStrategy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AvailabilityStrategy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SingleZoneValue = "SingleZone";
        private const string DualZoneValue = "DualZone";

        /// <summary> in single zone. </summary>
        public static AvailabilityStrategy SingleZone { get; } = new AvailabilityStrategy(SingleZoneValue);
        /// <summary> in two zones. </summary>
        public static AvailabilityStrategy DualZone { get; } = new AvailabilityStrategy(DualZoneValue);
        /// <summary> Determines if two <see cref="AvailabilityStrategy"/> values are the same. </summary>
        public static bool operator ==(AvailabilityStrategy left, AvailabilityStrategy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AvailabilityStrategy"/> values are not the same. </summary>
        public static bool operator !=(AvailabilityStrategy left, AvailabilityStrategy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AvailabilityStrategy"/>. </summary>
        public static implicit operator AvailabilityStrategy(string value) => new AvailabilityStrategy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AvailabilityStrategy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AvailabilityStrategy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
