// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Avs.Models
{
    public partial class AdminCredentials : IUtf8JsonSerializable, IJsonModel<AdminCredentials>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AdminCredentials>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AdminCredentials>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdminCredentials>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AdminCredentials)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(NsxtUsername))
            {
                writer.WritePropertyName("nsxtUsername"u8);
                writer.WriteStringValue(NsxtUsername);
            }
            if (options.Format != "W" && Optional.IsDefined(NsxtPassword))
            {
                writer.WritePropertyName("nsxtPassword"u8);
                writer.WriteStringValue(NsxtPassword);
            }
            if (options.Format != "W" && Optional.IsDefined(VCenterUsername))
            {
                writer.WritePropertyName("vcenterUsername"u8);
                writer.WriteStringValue(VCenterUsername);
            }
            if (options.Format != "W" && Optional.IsDefined(VCenterPassword))
            {
                writer.WritePropertyName("vcenterPassword"u8);
                writer.WriteStringValue(VCenterPassword);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AdminCredentials IJsonModel<AdminCredentials>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdminCredentials>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AdminCredentials)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAdminCredentials(document.RootElement, options);
        }

        internal static AdminCredentials DeserializeAdminCredentials(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string nsxtUsername = default;
            string nsxtPassword = default;
            string vcenterUsername = default;
            string vcenterPassword = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("nsxtUsername"u8))
                {
                    nsxtUsername = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("nsxtPassword"u8))
                {
                    nsxtPassword = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vcenterUsername"u8))
                {
                    vcenterUsername = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vcenterPassword"u8))
                {
                    vcenterPassword = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AdminCredentials(nsxtUsername, nsxtPassword, vcenterUsername, vcenterPassword, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AdminCredentials>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdminCredentials>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AdminCredentials)} does not support writing '{options.Format}' format.");
            }
        }

        AdminCredentials IPersistableModel<AdminCredentials>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdminCredentials>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAdminCredentials(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AdminCredentials)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AdminCredentials>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
