// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Addon type. </summary>
    internal readonly partial struct AddonType : IEquatable<AddonType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AddonType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AddonType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SRMValue = "SRM";
        private const string VRValue = "VR";
        private const string HCXValue = "HCX";
        private const string ArcValue = "Arc";

        /// <summary> SRM. </summary>
        public static AddonType SRM { get; } = new AddonType(SRMValue);
        /// <summary> VR. </summary>
        public static AddonType VR { get; } = new AddonType(VRValue);
        /// <summary> HCX. </summary>
        public static AddonType HCX { get; } = new AddonType(HCXValue);
        /// <summary> Arc. </summary>
        public static AddonType Arc { get; } = new AddonType(ArcValue);
        /// <summary> Determines if two <see cref="AddonType"/> values are the same. </summary>
        public static bool operator ==(AddonType left, AddonType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AddonType"/> values are not the same. </summary>
        public static bool operator !=(AddonType left, AddonType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AddonType"/>. </summary>
        public static implicit operator AddonType(string value) => new AddonType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AddonType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AddonType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
