// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> Addon provisioning state. </summary>
    public readonly partial struct AddonProvisioningState : IEquatable<AddonProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AddonProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AddonProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string CancelledValue = "Cancelled";
        private const string BuildingValue = "Building";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";

        /// <summary> Resource has been created. </summary>
        public static AddonProvisioningState Succeeded { get; } = new AddonProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static AddonProvisioningState Failed { get; } = new AddonProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static AddonProvisioningState Canceled { get; } = new AddonProvisioningState(CanceledValue);
        /// <summary> is cancelled. </summary>
        public static AddonProvisioningState Cancelled { get; } = new AddonProvisioningState(CancelledValue);
        /// <summary> is building. </summary>
        public static AddonProvisioningState Building { get; } = new AddonProvisioningState(BuildingValue);
        /// <summary> is deleting. </summary>
        public static AddonProvisioningState Deleting { get; } = new AddonProvisioningState(DeletingValue);
        /// <summary> is updating. </summary>
        public static AddonProvisioningState Updating { get; } = new AddonProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="AddonProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AddonProvisioningState left, AddonProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AddonProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AddonProvisioningState left, AddonProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AddonProvisioningState"/>. </summary>
        public static implicit operator AddonProvisioningState(string value) => new AddonProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AddonProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AddonProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
