// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Avs.Models
{
    /// <summary> The properties of an Arc addon. </summary>
    public partial class AddonArcProperties : AvsPrivateCloudAddonProperties
    {
        /// <summary> Initializes a new instance of <see cref="AddonArcProperties"/>. </summary>
        public AddonArcProperties()
        {
            AddonType = AddonType.Arc;
        }

        /// <summary> Initializes a new instance of <see cref="AddonArcProperties"/>. </summary>
        /// <param name="addonType"> Addon type. </param>
        /// <param name="provisioningState"> The state of the addon provisioning. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="vCenter"> The VMware vCenter resource ID. </param>
        internal AddonArcProperties(AddonType addonType, AddonProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData, string vCenter) : base(addonType, provisioningState, serializedAdditionalRawData)
        {
            VCenter = vCenter;
            AddonType = addonType;
        }

        /// <summary> The VMware vCenter resource ID. </summary>
        public string VCenter { get; set; }
    }
}
