// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Avs
{
    internal class WorkloadNetworkDhcpOperationSource : IOperationSource<WorkloadNetworkDhcpResource>
    {
        private readonly ArmClient _client;

        internal WorkloadNetworkDhcpOperationSource(ArmClient client)
        {
            _client = client;
        }

        WorkloadNetworkDhcpResource IOperationSource<WorkloadNetworkDhcpResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = WorkloadNetworkDhcpData.DeserializeWorkloadNetworkDhcpData(document.RootElement);
            return new WorkloadNetworkDhcpResource(_client, data);
        }

        async ValueTask<WorkloadNetworkDhcpResource> IOperationSource<WorkloadNetworkDhcpResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = WorkloadNetworkDhcpData.DeserializeWorkloadNetworkDhcpData(document.RootElement);
            return new WorkloadNetworkDhcpResource(_client, data);
        }
    }
}
