// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Avs
{
    internal class ExpressRouteAuthorizationOperationSource : IOperationSource<ExpressRouteAuthorizationResource>
    {
        private readonly ArmClient _client;

        internal ExpressRouteAuthorizationOperationSource(ArmClient client)
        {
            _client = client;
        }

        ExpressRouteAuthorizationResource IOperationSource<ExpressRouteAuthorizationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ExpressRouteAuthorizationData.DeserializeExpressRouteAuthorizationData(document.RootElement);
            return new ExpressRouteAuthorizationResource(_client, data);
        }

        async ValueTask<ExpressRouteAuthorizationResource> IOperationSource<ExpressRouteAuthorizationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ExpressRouteAuthorizationData.DeserializeExpressRouteAuthorizationData(document.RootElement);
            return new ExpressRouteAuthorizationResource(_client, data);
        }
    }
}
