// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Avs
{
    internal class AvsPrivateCloudDatastoreOperationSource : IOperationSource<AvsPrivateCloudDatastoreResource>
    {
        private readonly ArmClient _client;

        internal AvsPrivateCloudDatastoreOperationSource(ArmClient client)
        {
            _client = client;
        }

        AvsPrivateCloudDatastoreResource IOperationSource<AvsPrivateCloudDatastoreResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AvsPrivateCloudDatastoreData.DeserializeAvsPrivateCloudDatastoreData(document.RootElement);
            return new AvsPrivateCloudDatastoreResource(_client, data);
        }

        async ValueTask<AvsPrivateCloudDatastoreResource> IOperationSource<AvsPrivateCloudDatastoreResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AvsPrivateCloudDatastoreData.DeserializeAvsPrivateCloudDatastoreData(document.RootElement);
            return new AvsPrivateCloudDatastoreResource(_client, data);
        }
    }
}
