// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Avs
{
    internal class AvsPrivateCloudClusterOperationSource : IOperationSource<AvsPrivateCloudClusterResource>
    {
        private readonly ArmClient _client;

        internal AvsPrivateCloudClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        AvsPrivateCloudClusterResource IOperationSource<AvsPrivateCloudClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AvsPrivateCloudClusterData.DeserializeAvsPrivateCloudClusterData(document.RootElement);
            return new AvsPrivateCloudClusterResource(_client, data);
        }

        async ValueTask<AvsPrivateCloudClusterResource> IOperationSource<AvsPrivateCloudClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AvsPrivateCloudClusterData.DeserializeAvsPrivateCloudClusterData(document.RootElement);
            return new AvsPrivateCloudClusterResource(_client, data);
        }
    }
}
