// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Avs
{
    internal class AvsPrivateCloudAddonOperationSource : IOperationSource<AvsPrivateCloudAddonResource>
    {
        private readonly ArmClient _client;

        internal AvsPrivateCloudAddonOperationSource(ArmClient client)
        {
            _client = client;
        }

        AvsPrivateCloudAddonResource IOperationSource<AvsPrivateCloudAddonResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AvsPrivateCloudAddonData.DeserializeAvsPrivateCloudAddonData(document.RootElement);
            return new AvsPrivateCloudAddonResource(_client, data);
        }

        async ValueTask<AvsPrivateCloudAddonResource> IOperationSource<AvsPrivateCloudAddonResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AvsPrivateCloudAddonData.DeserializeAvsPrivateCloudAddonData(document.RootElement);
            return new AvsPrivateCloudAddonResource(_client, data);
        }
    }
}
