// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Avs
{
    internal class AvsCloudLinkOperationSource : IOperationSource<AvsCloudLinkResource>
    {
        private readonly ArmClient _client;

        internal AvsCloudLinkOperationSource(ArmClient client)
        {
            _client = client;
        }

        AvsCloudLinkResource IOperationSource<AvsCloudLinkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AvsCloudLinkData.DeserializeAvsCloudLinkData(document.RootElement);
            return new AvsCloudLinkResource(_client, data);
        }

        async ValueTask<AvsCloudLinkResource> IOperationSource<AvsCloudLinkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AvsCloudLinkData.DeserializeAvsCloudLinkData(document.RootElement);
            return new AvsCloudLinkResource(_client, data);
        }
    }
}
