// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Avs.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Avs
{
    public partial class AvsPrivateCloudData : IUtf8JsonSerializable, IJsonModel<AvsPrivateCloudData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AvsPrivateCloudData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AvsPrivateCloudData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvsPrivateCloudData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AvsPrivateCloudData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("sku"u8);
            writer.WriteObjectValue(Sku, options);
            if (Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                JsonSerializer.Serialize(writer, Identity);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(ManagementCluster))
            {
                writer.WritePropertyName("managementCluster"u8);
                writer.WriteObjectValue(ManagementCluster, options);
            }
            if (Optional.IsDefined(Internet))
            {
                writer.WritePropertyName("internet"u8);
                writer.WriteStringValue(Internet.Value.ToString());
            }
            if (Optional.IsCollectionDefined(IdentitySources))
            {
                writer.WritePropertyName("identitySources"u8);
                writer.WriteStartArray();
                foreach (var item in IdentitySources)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Availability))
            {
                writer.WritePropertyName("availability"u8);
                writer.WriteObjectValue(Availability, options);
            }
            if (Optional.IsDefined(Encryption))
            {
                writer.WritePropertyName("encryption"u8);
                writer.WriteObjectValue(Encryption, options);
            }
            if (Optional.IsCollectionDefined(ExtendedNetworkBlocks))
            {
                writer.WritePropertyName("extendedNetworkBlocks"u8);
                writer.WriteStartArray();
                foreach (var item in ExtendedNetworkBlocks)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(Circuit))
            {
                writer.WritePropertyName("circuit"u8);
                writer.WriteObjectValue(Circuit, options);
            }
            if (options.Format != "W" && Optional.IsDefined(Endpoints))
            {
                writer.WritePropertyName("endpoints"u8);
                writer.WriteObjectValue(Endpoints, options);
            }
            if (Optional.IsDefined(NetworkBlock))
            {
                writer.WritePropertyName("networkBlock"u8);
                writer.WriteStringValue(NetworkBlock);
            }
            if (options.Format != "W" && Optional.IsDefined(ManagementNetwork))
            {
                writer.WritePropertyName("managementNetwork"u8);
                writer.WriteStringValue(ManagementNetwork);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningNetwork))
            {
                writer.WritePropertyName("provisioningNetwork"u8);
                writer.WriteStringValue(ProvisioningNetwork);
            }
            if (options.Format != "W" && Optional.IsDefined(VMotionNetwork))
            {
                writer.WritePropertyName("vmotionNetwork"u8);
                writer.WriteStringValue(VMotionNetwork);
            }
            if (Optional.IsDefined(VCenterPassword))
            {
                writer.WritePropertyName("vcenterPassword"u8);
                writer.WriteStringValue(VCenterPassword);
            }
            if (Optional.IsDefined(NsxtPassword))
            {
                writer.WritePropertyName("nsxtPassword"u8);
                writer.WriteStringValue(NsxtPassword);
            }
            if (options.Format != "W" && Optional.IsDefined(VCenterCertificateThumbprint))
            {
                writer.WritePropertyName("vcenterCertificateThumbprint"u8);
                writer.WriteStringValue(VCenterCertificateThumbprint);
            }
            if (options.Format != "W" && Optional.IsDefined(NsxtCertificateThumbprint))
            {
                writer.WritePropertyName("nsxtCertificateThumbprint"u8);
                writer.WriteStringValue(NsxtCertificateThumbprint);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ExternalCloudLinks))
            {
                writer.WritePropertyName("externalCloudLinks"u8);
                writer.WriteStartArray();
                foreach (var item in ExternalCloudLinks)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(SecondaryCircuit))
            {
                writer.WritePropertyName("secondaryCircuit"u8);
                writer.WriteObjectValue(SecondaryCircuit, options);
            }
            if (options.Format != "W" && Optional.IsDefined(NsxPublicIPQuotaRaised))
            {
                writer.WritePropertyName("nsxPublicIpQuotaRaised"u8);
                writer.WriteStringValue(NsxPublicIPQuotaRaised.Value.ToString());
            }
            if (Optional.IsDefined(VirtualNetworkId))
            {
                writer.WritePropertyName("virtualNetworkId"u8);
                writer.WriteStringValue(VirtualNetworkId);
            }
            if (Optional.IsDefined(DnsZoneType))
            {
                writer.WritePropertyName("dnsZoneType"u8);
                writer.WriteStringValue(DnsZoneType.Value.ToString());
            }
            writer.WriteEndObject();
        }

        AvsPrivateCloudData IJsonModel<AvsPrivateCloudData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvsPrivateCloudData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AvsPrivateCloudData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAvsPrivateCloudData(document.RootElement, options);
        }

        internal static AvsPrivateCloudData DeserializeAvsPrivateCloudData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AvsSku sku = default;
            ManagedServiceIdentity identity = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            AvsManagementCluster managementCluster = default;
            InternetConnectivityState? internet = default;
            IList<SingleSignOnIdentitySource> identitySources = default;
            PrivateCloudAvailabilityProperties availability = default;
            CustomerManagedEncryption encryption = default;
            IList<string> extendedNetworkBlocks = default;
            AvsPrivateCloudProvisioningState? provisioningState = default;
            ExpressRouteCircuit circuit = default;
            AvsPrivateCloudEndpoints endpoints = default;
            string networkBlock = default;
            string managementNetwork = default;
            string provisioningNetwork = default;
            string vmotionNetwork = default;
            string vcenterPassword = default;
            string nsxtPassword = default;
            string vcenterCertificateThumbprint = default;
            string nsxtCertificateThumbprint = default;
            IReadOnlyList<ResourceIdentifier> externalCloudLinks = default;
            ExpressRouteCircuit secondaryCircuit = default;
            NsxPublicIPQuotaRaisedEnum? nsxPublicIPQuotaRaised = default;
            ResourceIdentifier virtualNetworkId = default;
            AvsDnsZoneType? dnsZoneType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sku"u8))
                {
                    sku = AvsSku.DeserializeAvsSku(property.Value, options);
                    continue;
                }
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = JsonSerializer.Deserialize<ManagedServiceIdentity>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("managementCluster"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            managementCluster = AvsManagementCluster.DeserializeAvsManagementCluster(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("internet"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            internet = new InternetConnectivityState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("identitySources"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SingleSignOnIdentitySource> array = new List<SingleSignOnIdentitySource>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SingleSignOnIdentitySource.DeserializeSingleSignOnIdentitySource(item, options));
                            }
                            identitySources = array;
                            continue;
                        }
                        if (property0.NameEquals("availability"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            availability = PrivateCloudAvailabilityProperties.DeserializePrivateCloudAvailabilityProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("encryption"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            encryption = CustomerManagedEncryption.DeserializeCustomerManagedEncryption(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("extendedNetworkBlocks"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            extendedNetworkBlocks = array;
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new AvsPrivateCloudProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("circuit"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            circuit = ExpressRouteCircuit.DeserializeExpressRouteCircuit(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("endpoints"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            endpoints = AvsPrivateCloudEndpoints.DeserializeAvsPrivateCloudEndpoints(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("networkBlock"u8))
                        {
                            networkBlock = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("managementNetwork"u8))
                        {
                            managementNetwork = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("provisioningNetwork"u8))
                        {
                            provisioningNetwork = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("vmotionNetwork"u8))
                        {
                            vmotionNetwork = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("vcenterPassword"u8))
                        {
                            vcenterPassword = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("nsxtPassword"u8))
                        {
                            nsxtPassword = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("vcenterCertificateThumbprint"u8))
                        {
                            vcenterCertificateThumbprint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("nsxtCertificateThumbprint"u8))
                        {
                            nsxtCertificateThumbprint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("externalCloudLinks"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ResourceIdentifier> array = new List<ResourceIdentifier>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                if (item.ValueKind == JsonValueKind.Null)
                                {
                                    array.Add(null);
                                }
                                else
                                {
                                    array.Add(new ResourceIdentifier(item.GetString()));
                                }
                            }
                            externalCloudLinks = array;
                            continue;
                        }
                        if (property0.NameEquals("secondaryCircuit"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            secondaryCircuit = ExpressRouteCircuit.DeserializeExpressRouteCircuit(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("nsxPublicIpQuotaRaised"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            nsxPublicIPQuotaRaised = new NsxPublicIPQuotaRaisedEnum(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("virtualNetworkId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            virtualNetworkId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("dnsZoneType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            dnsZoneType = new AvsDnsZoneType(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AvsPrivateCloudData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                sku,
                identity,
                managementCluster,
                internet,
                identitySources ?? new ChangeTrackingList<SingleSignOnIdentitySource>(),
                availability,
                encryption,
                extendedNetworkBlocks ?? new ChangeTrackingList<string>(),
                provisioningState,
                circuit,
                endpoints,
                networkBlock,
                managementNetwork,
                provisioningNetwork,
                vmotionNetwork,
                vcenterPassword,
                nsxtPassword,
                vcenterCertificateThumbprint,
                nsxtCertificateThumbprint,
                externalCloudLinks ?? new ChangeTrackingList<ResourceIdentifier>(),
                secondaryCircuit,
                nsxPublicIPQuotaRaised,
                virtualNetworkId,
                dnsZoneType,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AvsPrivateCloudData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvsPrivateCloudData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AvsPrivateCloudData)} does not support writing '{options.Format}' format.");
            }
        }

        AvsPrivateCloudData IPersistableModel<AvsPrivateCloudData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvsPrivateCloudData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAvsPrivateCloudData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AvsPrivateCloudData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AvsPrivateCloudData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
