// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Avs.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Avs
{
    /// <summary>
    /// A class representing the AvsPrivateCloudCluster data model.
    /// A cluster resource
    /// </summary>
    public partial class AvsPrivateCloudClusterData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AvsPrivateCloudClusterData"/>. </summary>
        /// <param name="sku"> The SKU (Stock Keeping Unit) assigned to this resource. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sku"/> is null. </exception>
        public AvsPrivateCloudClusterData(AvsSku sku)
        {
            Argument.AssertNotNull(sku, nameof(sku));

            Sku = sku;
            Hosts = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AvsPrivateCloudClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="sku"> The SKU (Stock Keeping Unit) assigned to this resource. </param>
        /// <param name="clusterSize"> The cluster size. </param>
        /// <param name="provisioningState"> The state of the cluster provisioning. </param>
        /// <param name="clusterId"> The identity. </param>
        /// <param name="hosts"> The hosts. </param>
        /// <param name="vsanDatastoreName"> Name of the vsan datastore associated with the cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AvsPrivateCloudClusterData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AvsSku sku, int? clusterSize, AvsPrivateCloudClusterProvisioningState? provisioningState, int? clusterId, IList<string> hosts, string vsanDatastoreName, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Sku = sku;
            ClusterSize = clusterSize;
            ProvisioningState = provisioningState;
            ClusterId = clusterId;
            Hosts = hosts;
            VsanDatastoreName = vsanDatastoreName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AvsPrivateCloudClusterData"/> for deserialization. </summary>
        internal AvsPrivateCloudClusterData()
        {
        }

        /// <summary> The SKU (Stock Keeping Unit) assigned to this resource. </summary>
        public AvsSku Sku { get; set; }
        /// <summary> The cluster size. </summary>
        public int? ClusterSize { get; set; }
        /// <summary> The state of the cluster provisioning. </summary>
        public AvsPrivateCloudClusterProvisioningState? ProvisioningState { get; }
        /// <summary> The identity. </summary>
        public int? ClusterId { get; }
        /// <summary> The hosts. </summary>
        public IList<string> Hosts { get; }
        /// <summary> Name of the vsan datastore associated with the cluster. </summary>
        public string VsanDatastoreName { get; set; }
    }
}
